# Prof-TC
# Avril 2022
# Caractéristique Générateur
# Tracé de U=f(I) pour un Générateur

#Affichage du nom du programme
print("_________________________________________________________")
print("Caracteristique d'un Générateur")
print("_________________________________________________________")

#Importation des bibliothèques
import matplotlib.pyplot as plt
import numpy as np

#Vleurs expérimentales à modifier selon l'expérience (U en volt et I en milliampère)
print("**********************************************")
ImA=[0, 2.6, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0]
U=[1.59, 1.31, 1.27, 1.16, 1.05, 0.95, 0.85, 0.74, 0.63, 0.52, 0.41, 0.32]
print("**********************************************")

# Nombre de points expérimentaux
K=len(U)

# Détermination des valeurs de I en Ampère
I=[]
for i in range(K):
    I.append(ImA[i]/1000)

#Affichage des valeurs expérimentales et du nombre de points
print("valeurs de I:, ",I)
print("valeurs de U: ",U)
print("Il y a ",K," couples de points")
print("**********************************************")

#Initialisation des variables
Imoy=0.0
Umoy=0.0
N=0.0
D=0.0
a=0.0
b=0.0
Imin=min(I)
Imax=max(I)
Umin=min(U)
Umax=max(U)

# Initialisation de la figure
fig, ax = plt.subplots()

#Calcul des coefficients de la droite représentant U=f(I)
for i in range (len(I)):
    Imoy=Imoy+I[i]
    Umoy=Umoy+U[i]

Imoy=Imoy/(len(I))
Umoy=Umoy/(len(U))

for i in range (len(I)):
    N=N+(I[i]-Imoy)*(U[i]-Umoy)
    D=D+(I[i]-Imoy)*(I[i]-Imoy)

a=N/D #Coefficient directeur de la droite
b=Umoy-a*Imoy #Ordonnée à l'origine de la droite

#Mise en écriture avec 5 décimales pour l'affichage de l'équation
Re=round(a,5)
Ee=round (b,5)

#Mise en écriture pour l'affichage de la résistance interne
R=-round(a,2)

#Mise en écriture pour l'affichage de la force électromotrice
E=round(b,2)

#Tracé des axes, labels et titre du graphique
plt.axis([Imin, Imax, Umin, Umax])
plt.xlabel('I (A)',color='green', fontsize=20)
plt.ylabel('U (V)',color='green', fontsize=20)
plt.title("Caractéristique d'un générateur", color='red', fontsize=10)
plt.grid()

#Tracé des valeurs expérimentales
plt.scatter(I,U,marker='o',color='r',linewidth = 4)

#Tracé de la droite
x=np.linspace(0,Imax+1,200)
y=a*x+b
plt.plot(x,y,linewidth = 2)

#Ecriture de l'équation de la droite
plt.text((Imax)/2, Umax-Umax*0.1, "U = "+str(E)+" - "+str(R)+ " x I", color='red', fontsize=12,horizontalalignment = 'center')

#Ecriture de la valeur de la Résistance
plt.text((Imax)/2, Umax-Umax*0.15, "R = "+str(R)+" Ohm", color='red', fontsize=12,horizontalalignment = 'center')

#Ecriture de la valeur de la Force Electromotrice
plt.text((Imax)/2, Umax-Umax*0.2, "E = "+str(E)+" Volt", color='red', fontsize=12,horizontalalignment = 'center')


#Affichage du graphique
plt.show()

# Sauvegarde de la figure dans le dossier où se trouve le programme
fig.savefig("CaracteristiqueGenerateur")

print("********************************************************")
print("L'équation de la droite est: U = ",E," - ",R," x I")
print("********************************************************")

#Fin du programme